/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: HandlerLayer.h                                                     *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              05/04/2007       1.1                              *
* Carlos Grossy              17/05/2007       1.2                              *
*******************************************************************************/

#ifndef _HANDLERLAYER_H_
#define _HANDLERLAYER_H_

#include "U4ATypes.h"
#include "HandlerPackage.h"
#include "HandlerMap.h"
#include "DescriptorLayer.h"
#include "Log.h"

class handlerLayer {
    private:
        handlerPackage *hp;
        handlerMap *hm;
        descriptorLayer *dl;
        log *l;
    public:
        handlerLayer();
        ~handlerLayer();
        bool send(int, char *, int, int);
        char* receive(int, bool&, int&, int);
        // Mapa
        void addEntry(int, int, int);
        void removeEntry(int);
        bool existsEntry(int);
        // Descriptores
        int requestDscIn(int, usbin);
        int requestDscOut(int, usbout);
        int buildDeviceId(int, int);
        int unBuildBoardPart(int);
        int unBuildSerialPart(int);
        int unBuildDscPart(int);
        int * getU4ABoards(int &);
};

#endif
